#ifndef _TWITTER_SONY_H
#define _TWITTER_SONY_H

#include "UnityNP.h"
#include "Mutex.h"

namespace UnityPlugin
{
	struct PostTwitter
	{
		const char* userText;
		const char* imagePath;
		int forbidAttachPhoto;		// Forbidden attach photo by user.
		int disableEditTweetMsg;	// Disable initial tweet message string.
		int forbidOnlyImageTweet;	// Forbid tweet of only a image.
		int forbidNoImageTweet;		// Forbid tweet of no image.
		int disableChangeImage;		// Disable change initial attached image.
		int limitToScreenShot;		// limit to user's screen shot.
	};

	typedef enum 
	{
		kDlgCanceled,
		kDlgOK,
	} TwitterResult;

	// Structure for returning result when an NP dialog is closed.
	struct TwitterReturn
	{
		TwitterResult result;				// Result, 0 = canceled, 1 = ok.
	};

	typedef enum 
	{
		kDlgNone,
		kDlgTwitter,
	} ActiveDialog;

	class Twitter
	{
		bool m_Busy;
		bool m_DialogOpen;
		ActiveDialog m_ActiveDialog;
		TwitterReturn m_Result;
		ResultCode m_LastResult;

	public:
		Twitter();

		bool IsBusy();
		ErrorCode GetLastError() const { return m_LastResult.GetResult(); }
		bool GetLastError(ResultCode* result) const { *result = m_LastResult; return m_LastResult.GetResult() == NP_OK; }
		bool IsDialogOpen() const { return m_DialogOpen; }

		ErrorCode StartDialog(PostTwitter* message);
		ErrorCode CancelDialog();
		void Update();

	private:
		bool LoadModules();
		void UpdateDialog();
	};

	extern Twitter gTwitter;
}

#endif // _TWITTER_SONY_H
